%define _unpackaged_files_terminate_build 1
%define oname zope.authentication

%def_with check

Name: python3-module-%oname
Version: 5.1
Release: alt1.1

Summary: Definition of authentication basics for the Zope Framework
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.authentication/
Vcs: https://github.com/zopefoundation/zope.authentication.git

Source: %name-%version.tar

# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %oname} = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.browser
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.security
%endif

%py3_requires zope zope.browser zope.component zope.i18nmessageid
%py3_requires zope.interface zope.schema zope.security

%description
This package provides a definition of authentication concepts for use in
Zope Framework.

%package tests
Summary: Tests for zope.authentication
Group: Development/Python3
Requires: %name = %version-%release

%description tests
This package provides a definition of authentication concepts for use in
Zope Framework.

This package contains tests for zope.authentication.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/zope/authentication
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests

%changelog
