%define oname zmq

%def_with bootstrap
%def_with check

Name: python3-module-%oname
Version: 27.1.0
Release: alt1

Summary: Software library for fast, message-based applications

Group: Development/Python3
License: LGPLv3+ and BSD-3-Clause
URL: https://pypi.org/project/pyzmq
VCS: https://github.com/zeromq/pyzmq
Source: %name-%version.tar

Provides: python3-module-pyzmq

BuildRequires(pre): rpm-build-python3
BuildRequires: libzeromq-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-Cython
BuildRequires: python3-module-packaging
BuildRequires: python3-module-tornado
BuildRequires: python3-module-scikit-build-core
BuildRequires: cmake
BuildRequires: gcc-c++
%if_without bootstrap
BuildRequires: python3-module-cffi
BuildRequires: python3-module-numpy
%endif
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-asyncio
%endif

%description
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialized messaging middle-ware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging
patterns, message filtering (subscriptions), seamless access to
multiple transport protocols and more.

This package contains the python bindings.

%package tests
Summary: Software library for fast, message-based applications
Group: Development/Python3
License: LGPLv3+

%description tests
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialized messaging middle-ware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging
patterns, message filtering (subscriptions), seamless access to
multiple transport protocols and more.

This package contains the testsuite for the python bindings.

%package devel
Summary: Software library for fast, message-based applications
Group: Development/Python3
Requires: %name = %version-%release

%description devel
The 0MQ lightweight messaging kernel is a library which extends the
standard socket interfaces with features traditionally provided by
specialized messaging middle-ware products. 0MQ sockets provide an
abstraction of asynchronous message queues, multiple messaging
patterns, message filtering (subscriptions), seamless access to
multiple transport protocols and more.

This package contains the headers for the python bindings.

# Nobody provides it
%add_python3_req_skip zmq.backend.cffi._cffi
%add_python3_req_skip zmq.eventloop.minitornado.ioloop
%add_python3_req_skip zmq.eventloop.minitornado.log
# https://cython.readthedocs.io/en/latest/src/tutorial/pure.html#cimports
%add_python3_req_skip cython.cimports.cpython
%add_python3_req_skip cython.cimports.libc.errno
%add_python3_req_skip cython.cimports.libc.stdint
%add_python3_req_skip cython.cimports.libc.stdio
%add_python3_req_skip cython.cimports.libc.stdlib
%add_python3_req_skip cython.cimports.libc.string
%add_python3_req_skip cython.cimports.zmq.backend.cython
%add_python3_req_skip cython.cimports.zmq.backend.cython._externs
%add_python3_req_skip cython.cimports.zmq.backend.cython.libzmq
%add_python3_req_skip cython.cimports.zmq.utils.buffers
%add_python3_req_skip cython.cimports.cpython.buffer
%add_python3_req_skip cython.cimports.cpython.bytes
%add_python3_req_skip cython.cimports.cpython.exc

%prep
%setup

# remove the Cython .c files in order to regenerate them:
find . -name "*.c" | xargs rm -v

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
# This test wants to build a custom cython extension, but does
# not have the source files installed into the buildroot
# That's why test_cython disabled, according to opensuse
# Note also that it should be build with build_ext --inplace
# to pass the tests, according to setup.py
# Tests are not passing in %%buildroot%%python3_sitelibdir
# because zmq's asyncio conflicts with python3-base's asyncio
# Maybe it somehow tied with paths
export PYTHONPATH=%buildroot%python3_sitelibdir
rm -v zmq/__init__.py
%pyproject_run_pytest -k "not test_cython"

%files
%doc README.md LICENSE.md CONTRIBUTING.md AUTHORS.md examples/
%python3_sitelibdir/*.dist-info
%python3_sitelibdir/%oname
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/*/*.h

%files devel
%python3_sitelibdir/%oname/*/*.h

%files tests
%python3_sitelibdir/%oname/tests

%changelog
