%define oname z3c.zcmlhook

%def_with check

Name: python3-module-%oname
Version: 2.1
Release: alt2

Summary: Easily hook into the ZCML processing machinery
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/z3c.zcmlhook/
Vcs: https://github.com/zopefoundation/z3c.zcmlhook

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
# runtime deps
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.interface
BuildRequires: python3-module-zope.schema
BuildRequires: python3-module-zope.configuration

# tests deps
BuildRequires: python3-module-zope.testrunner
# zope.component.testing is required but subpackaged
BuildRequires: python3-module-zope.component-tests
%endif

%description
This package provides means of hooking into the Zope (ZCML)
configuration process.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package provides means of hooking into the Zope (ZCML)
configuration process.

This package contains tests for z3c.zcmlhook.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst *.md
%python3_sitelibdir/z3c/zcmlhook/
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests


%changelog
