%define oname xhtml2pdf

%def_with check

Name: python3-module-%oname
Version: 0.2.17
Release: alt1

Summary: HTML/CSS to PDF converter based on Python

License: Apache-2.0
Group: Development/Python3
Url: http://www.xhtml2pdf.com/

# https://github.com/chrisglass/xhtml2pdf.git
Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-html5lib
Buildrequires: python3-module-Reportlab
Buildrequires: python3-module-asn1crypto
BuildRequires: python3-module-arabic-reshaper
BuildRequires: python3-module-bidi
BuildRequires: python3-module-pypdf
BuildRequires: python3-module-pyHanko
BuildRequires: python3-module-Pillow
%endif

%description
xhtml2pdf is a html2pdf converter using the ReportLab Toolkit, the
HTML5lib and pyPdf. It supports HTML 5 and CSS 2.1 (and some of CSS 3).
It is completely written in pure Python so it is platform independent.

The main benefit of this tool that a user with Web skills like HTML and
CSS is able to generate PDF templates very quickly without learning new
technologies.

%package demos
Summary: Demos for %oname
Group: Development/Documentation
Requires: python3-module-%oname = %EVR

%description demos
xhtml2pdf is a html2pdf converter using the ReportLab Toolkit, the
HTML5lib and pyPdf. It supports HTML 5 and CSS 2.1 (and some of CSS 3).
It is completely written in pure Python so it is platform independent.

The main benefit of this tool that a user with Web skills like HTML and
CSS is able to generate PDF templates very quickly without learning new
technologies.

This package contains demos for %oname.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
# test_document_cannot_identify_image and test_document_with_broken_image
# try to download images from network
py.test-3 -v -k 'not test_document_cannot_identify_image and not test_document_with_broken_image'

%files
%doc *.txt *.rst
%_bindir/pisa
%_bindir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%files demos
%doc demo/*

%changelog
