%define _unpackaged_files_terminate_build 1
%define oname veusz

Name: python3-module-%oname
Version: 4.2
Release: alt1

Summary: A Scientific Plotting Package
License: GPL-2.0-or-later
Group: Development/Python3
URL: https://veusz.github.io
VCS: https://github.com/veusz/veusz.git

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: rpm-macros-python3
BuildRequires: rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: /usr/bin/pod2man /usr/bin/man
BuildRequires: python3-devel libnumpy-py3-devel
BuildRequires: qt6-base-devel python3-module-PyQt6-devel
BuildRequires: python3-module-sip6
BuildRequires: python3(tomli)
BuildRequires: desktop-file-utils
BuildRequires: qt6-designer

%add_python3_req_skip pyemf3 pyemf3.emr
%py3_requires numpy.testing

%description
Veusz is a GUI scientific plotting and graphing package. It is designed
to produce publication-ready Postscript or PDF output. SVG, EMF and
bitmap export formats are also supported. The program runs under
Unix/Linux, Windows or Mac OS X, and binaries are provided. Data can be
read from text, CSV or FITS files, and data can be manipulated or
examined from within the application.

%package docs
Summary: Documentation for Veusz
Group: Development/Documentation
BuildArch: noarch

%description docs
Veusz is a GUI scientific plotting and graphing package. It is designed
to produce publication-ready Postscript or PDF output. SVG, EMF and
bitmap export formats are also supported. The program runs under
Unix/Linux, Windows or Mac OS X, and binaries are provided. Data can be
read from text, CSV or FITS files, and data can be manipulated or
examined from within the application.

This packagec contains documentation for Veusz.

%package examples
Summary: Examples for Veusz
Group: Development/Documentation
Requires: %name = %EVR

%description examples
Veusz is a GUI scientific plotting and graphing package. It is designed
to produce publication-ready Postscript or PDF output. SVG, EMF and
bitmap export formats are also supported. The program runs under
Unix/Linux, Windows or Mac OS X, and binaries are provided. Data can be
read from text, CSV or FITS files, and data can be manipulated or
examined from within the application.

This package contains examples for Veusz.

%package -n %oname
Summary: A Scientific Plotting Package
Group: Graphics
Conflicts: %name < %version-%release
Requires: %name = %EVR
Requires: %name-examples = %EVR

%description -n %oname
Veusz is a GUI scientific plotting and graphing package. It is designed
to produce publication-ready Postscript or PDF output. SVG, EMF and
bitmap export formats are also supported. The program runs under
Unix/Linux, Windows or Mac OS X, and binaries are provided. Data can be
read from text, CSV or FITS files, and data can be manipulated or
examined from within the application.

This package contains main scripts for Veusz.

%prep
%setup
%autopatch -p1
find ./ -type f -name '*.py' -exec \
	sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' '{}' +

%build
#add_optflags -fno-strict-aliasing
%pyproject_build
%make_build -C Documents/ man

# make translations
lrelease-qt6 translation/*.ts

%install
%pyproject_install

# Install .desktop, mime and appdata files from upstream tarball
install -Dm0644 support/veusz.appdata.xml %buildroot%_datadir/appdata/veusz.appdata.xml
install -Dm0644 support/veusz.xml %buildroot/%_datadir/mime/packages/veusz.xml
desktop-file-install -m 0644 \
	--dir=%buildroot%_desktopdir/ \
	--add-category=2DGraphics \
	support/veusz.desktop

# link main veusz icon also into hicolor-icon-theme dir (for desktop file)
for size in 16 32 48 64 128; do
	odir=%buildroot%_iconsdir/hicolor/${size}x${size}/apps
	mkdir -p $odir
	ln -s %python3_sitelibdir/veusz/icons/veusz_${size}.png ${odir}/veusz.png
done
odir=%buildroot%_iconsdir/hicolor/scalable/apps
mkdir -p $odir
ln -s %python3_sitelibdir/veusz/icons/veusz.svg $odir/veusz.svg

# install man pages
mkdir -p %buildroot%_man1dir
install -p Documents/man-page/veusz.1 -m 0644 %buildroot%_man1dir

# install translations
mkdir -p %buildroot/%_datadir/%oname/translation
cp translation/*.qm %buildroot/%_datadir/%oname/translation/
%find_lang --with-qt %oname

%files
%python3_sitelibdir/veusz-%version.dist-info
%python3_sitelibdir/veusz
%exclude %python3_sitelibdir/veusz/examples

%files examples
%python3_sitelibdir/veusz/examples

%files -n %oname -f %oname.lang
%doc AUTHORS ChangeLog COPYING README.md
%_bindir/veusz
%_datadir/applications/veusz.desktop
%_datadir/appdata/veusz.appdata.xml
%_iconsdir/hicolor/*/apps/veusz.*
%_datadir/mime/packages/veusz.xml
%_man1dir/*
%dir %_datadir/%oname
%dir %_datadir/%oname/translation

%changelog
