%define oname venusian

%def_without docs
%def_with check

Name: python3-module-%oname
Version: 3.1.1
Release: alt1.1

Summary: A library for deferring decorator actions

License: BSD-4-Clause
Group: Development/Python3
URL: https://pypi.org/project/venusian
VCS: https://github.com/Pylons/venusian

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest-cov
%endif

%if_with docs
BuildRequires: python3-module-sphinx
%endif

%add_python3_req_skip doesnt.exist

%add_python3_self_prov_path %buildroot%python3_sitelibdir/%oname/tests

%description
Venusian is a library which allows framework authors to defer decorator
actions. Instead of taking actions when a function (or class) decorator
is executed at import time, you can defer the action usually taken by
the decorator until a separate "scan" phase.

%package tests
Summary: Tests for Venusian
Group: Development/Python3
Requires: %name = %version-%release

%description tests
Venusian is a library which allows framework authors to defer decorator
actions. Instead of taking actions when a function (or class) decorator
is executed at import time, you can defer the action usually taken by
the decorator until a separate "scan" phase.

This package contains tests for Venusian.

%if_with docs
%package pickles
Summary: Pickles for Venusian
Group: Development/Python3

%description pickles
Venusian is a library which allows framework authors to defer decorator
actions. Instead of taking actions when a function (or class) decorator
is executed at import time, you can defer the action usually taken by
the decorator until a separate "scan" phase.

This package contains pickles for Venusian.

%package docs
Summary: Documentation for Venusian
Group: Development/Documentation

%description docs
Venusian is a library which allows framework authors to defer decorator
actions. Instead of taking actions when a function (or class) decorator
is executed at import time, you can defer the action usually taken by
the decorator until a separate "scan" phase.

This package contains documentation for Venusian.
%endif

%prep
%setup

%if_with docs
sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile
%endif

%build
%pyproject_build

%install
%pyproject_install

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
pushd docs
%make pickle
%make html
cp -fR _build/pickle %buildroot%python3_sitelibdir/%oname/
popd
%endif

cp -fR tests/ %buildroot%python3_sitelibdir/%oname/

%check
%tox_check_pyproject

%files
%doc *.txt *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/%oname/tests
%if_with docs
%exclude %python3_sitelibdir/%oname/pickle
%endif

%files tests
%python3_sitelibdir/%oname/tests

%if_with docs
%files pickles
%python3_sitelibdir/%oname/pickle

%files docs
%doc docs/_build/html/*
%endif

%changelog
