%define _unpackaged_files_terminate_build 1
%define pypi_name uvloop
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 0.22.1
Release: alt1

Summary: Ultra fast asyncio event loop
License: MIT and Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/uvloop/
Vcs: https://github.com/MagicStack/uvloop

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: libuv-devel

%if_with check
%pyproject_builddeps_metadata_extra test
%pyproject_builddeps_check
BuildRequires: python3-module-pytest
BuildRequires: /proc
BuildRequires: /dev/pts
%endif

%description
uvloop is a fast, drop-in replacement of the built-in asyncio event loop.
uvloop is implemented in Cython and uses libuv under the hood.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%global build_option "build_ext", "--cython-always","--use-system-libuv"
%pyproject_build \
  --backend-config-settings='{"--build-option": [%build_option]}'

%install
%pyproject_install
# Do not package a module for testing.
%__rm %buildroot%python3_sitelibdir/%mod_name/_testbase.py

%check
# Tests 'test_write_buffer_full' disabled because of:
# https://github.com/MagicStack/uvloop/issues/576
%__rm -rf %mod_name
%pyproject_run_pytest \
%ifarch ppc64le
    -k 'not test_write_buffer_full' \
%endif
    -vra

%files
%doc README.rst LICENSE-APACHE LICENSE-MIT
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
