%define _unpackaged_files_terminate_build 1
%define optflags_lto %nil
%define pypi_name uv
%define mod_name %pypi_name
%define uv_version 0.9.4

%define pypi_name_uv_build uv-build
%define mod_name_uv_build uv_build
%define uv_build_version %uv_version
%define uv_build_backend_dir crates/uv-build
%define bash_completions_dir %_datadir/bash-completion/completions

%def_with check

Name: python3-module-%pypi_name
Version: %uv_version
Release: alt1
Summary: An extremely fast Python package installer and resolver
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/uv
Vcs: https://github.com/astral-sh/uv
Source: %name-%version.tar
Source1: vendor_rust.tar
Source2: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
Requires: %pypi_name
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: /usr/bin/cmake
BuildRequires: libssl-devel
%if_with check
%pyproject_builddeps_metadata
%endif

%description
An extremely fast Python package installer and resolver, written in Rust.
Designed as a drop-in replacement for common pip and pip-tools workflows.

%package -n %pypi_name
Summary: %summary
Group: Development/Python3
# uv executable was shipped in python package
Conflicts: python3-module-%pypi_name <= 0.5.26-alt1

%description -n %pypi_name
%summary.

%package -n %pypi_name_uv_build
Version: %uv_build_version
Summary: Executable for uv build backend
Group: Development/Python3

%description -n %pypi_name_uv_build
%summary.

%package build
Version: %uv_build_version
Summary: uv build backend
Group: Development/Python3
Requires: %pypi_name_uv_build

%description build
%summary.

%prep
%setup -a1
%autopatch -p1
cat < vendor_cargoconf.toml >> .cargo/config.toml
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
export CARGO_TERM_VERBOSE=true
%ifarch %ix86
# fails with upstream's lto=fat
export CARGO_PROFILE_RELEASE_LTO=thin
%endif
%pyproject_build

# build uv build backend
pushd %uv_build_backend_dir
%pyproject_build
popd

%install
%pyproject_install

# install uv build backend
pushd %uv_build_backend_dir
%pyproject_install
popd

# install bash completion
# https://docs.astral.sh/uv/getting-started/installation/#shell-autocompletion
mkdir -p %buildroot%bash_completions_dir
%buildroot%_bindir/uv generate-shell-completion \
    bash > %buildroot%bash_completions_dir/uv
%buildroot%_bindir/uvx --generate-shell-completion \
    bash > %buildroot%bash_completions_dir/uvx

%check
# smoke tests: .github/workflows/build-binaries.yml
%pyproject_run -- bash -s <<-'ENDTESTS'
set -eux
uv --help
python -m uv --help
uvx --help
ENDTESTS

pushd %uv_build_backend_dir
%pyproject_run -- bash -s <<-'ENDTESTS'
set -eux
uv-build --help
python -m uv_build --help
ENDTESTS
popd

%files
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pep427_name %pypi_name}-%uv_version.dist-info/

%files build
%python3_sitelibdir/%mod_name_uv_build/
%python3_sitelibdir/%{pep427_name %pypi_name_uv_build}-%uv_build_version.dist-info/

%files -n %pypi_name
%doc README.*
%_bindir/uv
%_bindir/uvx
%bash_completions_dir/uv
%bash_completions_dir/uvx

%files -n %pypi_name_uv_build
%_bindir/uv-build

%changelog
