%define oname urwid

%def_with check

Name: python3-module-urwid
Version: 3.0.3
Release: alt1

Summary: Urwid is a console user interface library for Python.

License: LGPLv2.1
Group: Development/Python3
URL: https://pypi.org/project/urwid
VCS: https://github.com/urwid/urwid

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-setuptools-scm
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: /dev/pts
BuildRequires: python3-module-typing-extensions
BuildRequires: python3-module-wcwidth
BuildRequires: python3-module-coverage
BuildRequires: python3-modules-curses
%endif

# These requirements are optional
# https://github.com/urwid/urwid/blob/master/urwid/__init__.py#L221
%add_python3_req_skip gi.repository
%add_python3_req_skip tornado
%add_python3_req_skip trio
%add_python3_req_skip twisted.internet.abstract
%add_python3_req_skip twisted.internet.error
%add_python3_req_skip zmq

%py3_provides %oname

BuildArch:     noarch

%description
Urwid is a console user interface library for Python. Urwid is released
under the GNU Lesser General Public License and it includes many features
useful for text console application developers:

 * Fluid interface resizing (xterm window resizing / fbset on Linux console)
 * Web application display mode using Apache and CGI [ Live Demo ]
 * Support for UTF-8, simple 8-bit and CJK encodings
 * Multiple text alignment and wrapping modes built-in
 * Ability create user-defined text layout classes
 * Simple markup for setting text attributes
 * Powerful list box that handles scrolling between different widget types
 * List box contents may be managed with a user-defined class
 * Flexible edit box for editing many different types of text
 * Buttons, check boxes and radio boxes
 * Customizable layout for all widgets
 * Easy interface for creating HTML screen shots

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc *.rst examples
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
