%define _unpackaged_files_terminate_build 1
%define pypi_name urllib3
%define mod_name %pypi_name

%define add_python_extra() \
%{expand:%%package -n %%name+%1 \
Summary: %%summary \
Group: Development/Python3 \
Requires: %%name \
%{expand:%%pyproject_runtimedeps_metadata -- --extra %1} \
%%description -n %%name+%1' \
Extra "%1" for %%pypi_name. \
%%files -n %%name+%1 \
}

# tests suite is very unstable (freezes or crashes) on arches different from
# x86_64
%if %_arch == x86_64
%def_with check
%else
%def_without check
%endif

Name: python3-module-%pypi_name
Version: 2.5.0
Release: alt1
Epoch: 2
Summary: HTTP library with thread-safe connection pooling, file post, and more
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/urllib3/
Vcs: https://github.com/urllib3/urllib3
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version.patch
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter pytest-memray
%add_pyproject_deps_check_filter towncrier
%pyproject_builddeps_metadata_extra socks
%pyproject_builddeps_metadata_extra brotli
%pyproject_builddeps_metadata_extra zstd
%pyproject_builddeps_metadata_extra h2
%pyproject_builddeps_check
%endif

%description
urllib3 is a powerful, user-friendly HTTP client for Python.

%add_python_extra brotli
%add_python_extra socks
%add_python_extra zstd
%add_python_extra h2

%prep
%setup
%patch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup dev
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# to adjust timeouts: test.LONG_TIMEOUT
export CI=yes
export NO_VENDORED_HYPERCORN=yes
%pyproject_run_pytest -ra

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
