%define _unpackaged_files_terminate_build 1
%define pypi_name tzlocal

Name: python3-module-%pypi_name
Version: 5.3.1
Release: alt2

Summary: A Python module that tries to figure out what your local timezone is

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/tzlocal/
Vcs: https://github.com/regebro/tzlocal

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-mock

%description
This Python module returns the IANA time zone name for your local
time zone or a tzinfo object with the local timezone information,
under Unix and Windows.

This module attempts to fix a glaring hole in the pytz and zoneinfo
modules, that there is no way to get the local timezone information,
unless you know the zoneinfo name, and under several Linux distros
that's hard or impossible to figure out.

With tzlocal you only need to call get_localzone() and you will get
a tzinfo object with the local time zone info. On some Unices you
will still not get to know what the timezone name is, but you don't
need that when you have the tzinfo file. However, if the timezone
name is readily available it will be used.

%prep
%setup

# fix symlink, required for test: https://github.com/regebro/tzlocal/issues/53
ln -sfv ../usr/share/zoneinfo/Africa/Harare \
   tests/test_data/symlink_localtime/etc/localtime

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject -- -vra -k 'not test_conflicting and not test_noconflict'

%files
%doc CHANGES.txt LICENSE.txt README.rst
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}
%python3_sitelibdir_noarch/%{pep427_name %pypi_name}

%changelog
