%define pypi_name trio

%def_with check

Name: python3-module-%pypi_name
Version: 0.31.0
Release: alt1
Summary: Trio - Pythonic async I/O for humans and snake people
License: MIT or Apache-2.0
Group: Development/Python3
URL: https://pypi.org/project/trio
VCS: https://github.com/python-trio/trio
BuildArch: noarch
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: /proc
BuildRequires: python3-module-pytest
BuildRequires: python3-module-attrs
BuildRequires: python3-module-sniffio
BuildRequires: python3-module-outcome
BuildRequires: python3-module-sortedcontainers
BuildRequires: python3-module-idna
# these are optional
BuildRequires: python3-module-trustme
BuildRequires: python3-module-astor
BuildRequires: python3-module-openssl
BuildRequires: python3-module-isort
%endif

# Self provides
%add_python3_req_skip _common simple_excepthook
# Only in ubuntu
%add_python3_req_skip apport_python_hook

%description
The Trio project's goal is to produce a production-quality, permissively
licensed, async/await-native I/O library for Python. Like all async libraries,
its main purpose is to help you write programs that do multiple things at the
same time with parallelized I/O.

%package tests
Summary: Tests for %pypi_name
Group: Development/Python3
Requires: %name = %EVR

%description tests
The Trio project's goal is to produce a production-quality, permissively
licensed, async/await-native I/O library for Python. Like all async libraries,
its main purpose is to help you write programs that do multiple things at the
same time with parallelized I/O.

This package contains tests for %pypi_name.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
# see ci.sh for details
%pyproject_run_pytest -ra \
    --pyargs trio --verbose \
    -p trio._tests.pytest_plugin \
    --skip-optional-imports \
    -m 'not redistributors_should_skip' \

%files
%doc README.*
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}
%exclude %python3_sitelibdir/%pypi_name/_tests
%exclude %python3_sitelibdir/%pypi_name/testing
%exclude %python3_sitelibdir/%pypi_name/_core/_tests

%files tests
%python3_sitelibdir/%pypi_name/_tests
%python3_sitelibdir/%pypi_name/testing
%python3_sitelibdir/%pypi_name/_core/_tests

%changelog
