%define oname triangle

%def_with check

Name: python3-module-%oname
Version: 2022.02.02
Release: alt2

Summary: Python wrapper for libtriangle

License: LGPL-3.0
Group: Development/Python3
Url: https://rufat.be/triangle/
Vcs: https://github.com/drufat/triangle.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-Cython
%if_with check
BuildRequires: python3-module-numpy
BuildRequires: python3-module-pytest
%endif

%description
Python Triangle is a python wrapper around Jonathan Richard Shewchuk's
two-dimensional quality mesh generator and delaunay triangulator
library.

%prep
%setup
# Force re-cythonize for python3.11
cython3 triangle/core.pyx

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3 -v tests

%files
%doc *.rst LICENSE
%python3_sitelibdir/*

%changelog
