%def_with check

%define  modulename treq
Name:    python3-module-%modulename
Version: 22.2.0
Release: alt2.1

Summary: Python requests like API built on top of Twisted's HTTP client
License: MIT
Group:   Development/Python3
URL:     https://github.com/twisted/treq

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
BuildRequires: python3-module-wheel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-incremental
%if_with check
BuildRequires: python3(twisted)
BuildRequires: python3(twisted.trial)
BuildRequires: python3(twisted.web)
BuildRequires: python3(twisted.words)
BuildRequires: python3(requests)
BuildRequires: python3(service_identity)
BuildRequires: python3(httpbin)
BuildRequires: python3-module-twisted-core-tests
BuildRequires: python3-module-legacy-cgi
%endif

BuildArch: noarch

Source:  %modulename-%version.tar

%description
treq is an HTTP library inspired by requests but written on top of Twisted's
Agents.

It provides a simple, higher level API for making HTTP requests when using
Twisted.

%prep
%setup -n %modulename-%version

%build
%pyproject_build

%install
%pyproject_install
# cleanup tests
rm -rf %buildroot%python3_sitelibdir/%modulename/test
rm -rf %buildroot%python3_sitelibdir/%modulename/testing.py

%check
export PYTHONDONTWRITEBYTECODE=1
export PYTHONPATH=%buildroot/%python3_sitelibdir/
trial treq || exit 1

%files
%python3_sitelibdir/%modulename/
%python3_sitelibdir/%modulename-%version.dist-info

%changelog
