%define oname tqdm

%def_with check

Name: python3-module-tqdm
Version: 4.67.1
Release: alt1

Summary: A fast, extensible progress bar for Python and CLI

License: MIT and MPL-2.0
Group: Development/Python
Url: https://pypi.org/project/tqdm

Source: %name-%version.tar

BuildArch: noarch

Conflicts: python-module-%oname
Obsoletes: python-module-%oname

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-asyncio
BuildRequires: python3-module-pytest-timeout
BuildRequires: python3-module-numpy
%endif

# make optional
%add_python3_req_skip dask.callbacks rich.progress

%description
tqdm means "progress" in Arabic (taqadum) and an abbreviation
for "I love you so much" in Spanish (te quiero demasiado).

Instantly make your loops show a smart progress meter -
just wrap any iterable with tqdm(iterable), and you're done!

%prep
%setup
sed -ie 's/timeout = 30/timeout = 60/' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
# https://github.com/tqdm/tqdm/issues/1537
%pyproject_run_pytest -v

%files
%doc *.rst
%_bindir/tqdm
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
