%define _unpackaged_files_terminate_build 1
%define pypi_name tox
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 4.32.0
Release: alt1

Summary: Generic virtualenv management and test command line tool
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/tox/
VCS: https://github.com/tox-dev/tox
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /proc
# required by test_local_execute_terminal_size
BuildRequires: /dev/pts
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Tox as is a generic virtualenv management and test command line tool you
can use for:

* checking your package installs correctly with different Python
  versions and interpreters
* running your tests in each of the environments, configuring your test
  tool of choice
* acting as a frontend to Continuous Integration servers, greatly
  reducing boilerplate and merging CI and shell-based testing.

%prep
%setup
%patch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup test
%endif

%build
%pyproject_build

%install
%pyproject_install

pushd %buildroot%_bindir
for i in $(ls); do
        mv $i $i.py3
done
popd

%check
export VIRTUALENV_SYSTEM_SITE_PACKAGES=YES
export TOX_LIMITED_SHEBANG=1
export PIP_NO_BUILD_ISOLATION=NO
%pyproject_run_pytest -vra

%files
%_bindir/tox.py3
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
