%define oname tornado

%def_with check

Name: python3-module-%oname
Version: 6.5.2
Release: alt1

Summary: Scalable, non-blocking web server and tools

License: Apache-2.0
Group: Development/Python3
URL: https://pypi.org/project/tornado
VCS: https://github.com/tornadoweb/tornado

Source: %name-%version.tar
Patch: Do-not-turn-DeprecationWarning-into-Exception.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
Requires: ca-certificates python3-module-certifi
%add_python3_req_skip MySQLdb pycurl

%description
Tornado is an open source version of the scalable, non-blocking web
server and tools.

The framework is distinct from most mainstream web server frameworks
(and certainly most Python frameworks) because it is non-blocking and
reasonably fast. Because it is non-blocking and uses epoll, it can
handle thousands of simultaneous standing connections, which means it is
ideal for real-time web services.

%prep
%setup
%patch -p1
# remove shebang from files
sed -i.orig -e '/^#!\//, 1d' *py tornado/*.py tornado/*/*.py

%build
%pyproject_build

%install
%pyproject_install
pushd %buildroot%python3_sitelibdir/%oname
ln -sf /usr/share/ca-certificates/ca-bundle.crt ca-certificates.crt

# do not install tests
rm -r %buildroot%python3_sitelibdir/tornado/test

%check
export ASYNC_TEST_TIMEOUT=120
%__python3 -m tornado.test.runtests --verbose

%files
%doc LICENSE *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
