%define _unpackaged_files_terminate_build 1
%define pypi_name toml

%def_with check

Name: python3-module-%pypi_name
Version: 0.10.2
Release: alt4
Summary: A Python library for parsing and creating TOML.
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/toml/
Vcs: https://github.com/uiri/toml
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: golang-github-burntsushi-toml-test
%endif

%description
TOML aims to be a minimal configuration file format that's easy to read due to
obvious semantics. TOML is designed to map unambiguously to a hash table. TOML
should be easy to parse into data structures in a wide variety of languages.
This package loads toml file into python dictionary and dump dictionary into
toml file.

%prep
%setup
%patch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
ln -s %_datadir/toml-test toml-test
%pyproject_run_pytest -vra

%files
%python3_sitelibdir/toml/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
