%define _unpackaged_files_terminate_build 1
%define pypi_name taskiq-dependencies
%define mod_name taskiq_dependencies

%def_with check

Name: python3-module-%pypi_name
Version: 1.5.7
Release: alt1

Summary: FastAPI-like dependency injection implementation
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/taskiq-dependencies/
Vcs: https://github.com/taskiq-python/taskiq-dependencies

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter types-
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
This project is used to add FastAPI-like dependency injection to
projects.

This project is a part of the taskiq, but it doesn't have any
dependencies, and you can easily integrate it in any project.

%prep
%setup
%autopatch -p1

# set version manually, not via poetry
sed -i '/^version =/s/.*/version="%version"/' pyproject.toml

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_poetry dev
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra -o=addopts=-Wignore

%files
%doc LICENSE README.md
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
