%define _unpackaged_files_terminate_build 1
%define pypi_name taskiq
%define mod_name taskiq

%def_with check

Name: python3-module-%pypi_name
Version: 0.11.16
Release: alt1

Summary: Distributed task queue with full async support
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/taskiq/
Vcs: https://github.com/taskiq-python/taskiq

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%set_pyproject_deps_check_filter types-
%pyproject_builddeps_metadata_extra orjson
%pyproject_builddeps_metadata_extra cbor
%pyproject_builddeps_metadata_extra msgpack
%pyproject_builddeps_check
%endif

%description
Taskiq is an asynchronous distributed task queue for python. This
project takes inspiration from big projects such as Celery and Dramatiq.
But taskiq can send and run both the sync and async functions. Also, we
use PEP-612 to provide the best autosuggestions possible. But since it's
a new PEP, I encourage you to use taskiq with VS code because Pylance
understands all types correctly.

%prep
%setup
%autopatch -p1

# set version manually, not via poetry
sed -i '/^version =/s/.*/version="%version"/' pyproject.toml

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_poetry dev
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra -o=addopts=-Wignore

%files
%doc LICENSE README.md
%_bindir/taskiq
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
