%define oname stevedore
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 5.5.0
Release: alt1

Summary: Manage dynamic plugins for Python applications

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/stevedore

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0

%if_with check
BuildRequires: python3-module-mock
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-coverage >= 4.0
%endif

%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-sphinx-devel
%endif

%description
Python makes loading code dynamically easy, allowing you to configure and extend
your application by discovering and loading extensions ("plugins") at runtime.
Many applications implement their own library for doing this, using __import__
or importlib. stevedore avoids creating yet another extension mechanism
by building on top of setuptools entry points. The code for managing entry points
tends to be repetitive, though, so stevedore provides manager classes for
implementing common patterns for using dynamically loaded extensions.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/%oname.1 %buildroot%_man1dir/%oname.1
%endif

%check
%__python3 -m stestr run
#export PYTHONPATH=$PWD
# use pytest instead of stestr to break a build cycle between python-cliff, python-stestr and python-stevedore
#__python3 -m pytest stevedore/tests -k "not test_extension"

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/example
%exclude %python3_sitelibdir/%oname/example2

%files tests
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/example
%python3_sitelibdir/%oname/example2

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
