%define _unpackaged_files_terminate_build 1
%define pypi_name starlette

%def_with check

Name: python3-module-%pypi_name
Version: 0.47.1
Release: alt2

Summary: The little ASGI framework that shines
License: BSD-3-Clause
Group: Development/Python3
Url: https://www.starlette.io
Vcs: https://github.com/encode/starlette

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata_extra full
%pyproject_builddeps_check
%endif

%description
Starlette is a lightweight ASGI framework/toolkit, which is ideal for
building async web services in Python.

It is production-ready, and gives you the following:
- A lightweight, low-complexity HTTP web framework.
- WebSocket support.
- In-process background tasks.
- Startup and shutdown events.
- Test client built on httpx.
- CORS, GZip, Static Files, Streaming responses.
- Session and Cookie support.
- 100%% test coverage.
- 100%% type annotated codebase.
- Few hard dependencies.
- Compatible with asyncio and trio backends.
- Great overall performance against independent benchmarks.

%prep
%setup
%autopatch -p1
sed -n '/^# Testing$/,/^[[:space:]]*$/p' requirements.txt | \
    tee test-requirements.txt
cat alt-test-requirements.txt | tee -a test-requirements.txt
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile test-requirements.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -Wignore -q --timeout 120

%files
%doc README.*
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
