%define _unpackaged_files_terminate_build 1
%define pypi_name sqlitedict

%def_with check

Name: python3-module-%pypi_name
Version: 2.1.0
Release: alt1
Summary: Persistent dict in Python, backed up by sqlite3 and pickle, multithread-safe
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/sqlitedict/
VCS: https://github.com/RaRe-Technologies/sqlitedict

Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(sqlite3)
%endif

%description
A lightweight wrapper around Python's sqlite3 database, with a dict-like
interface and multi-thread access support.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
mkdir tests/db
%tox_check_pyproject -- -vra tests

%files
%doc *.rst
%python3_sitelibdir/sqlitedict.py
%python3_sitelibdir/__pycache__/sqlitedict.*
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
