%define _unpackaged_files_terminate_build 1
%define pypi_name sqlalchemy
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 2.0.44
Release: alt2

Summary: Python SQL toolkit and Object Relational Mapper
License: MIT
Group: Development/Python
Url: https://pypi.org/project/sqlalchemy
Vcs: https://github.com/sqlalchemy/sqlalchemy
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%py3_provides SQLAlchemy
Provides: python3-module-SQLAlchemy = %EVR
Obsoletes: python3-module-SQLAlchemy
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
# Make sure that at least the Python built-in sqlite driver
# is present (and can be used by SQLAlchemy--among other things--
# in various tests, like in the tests for sphinx).
Requires: python3-modules-sqlite3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra asyncio
%pyproject_builddeps_check
%endif

%description
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

%package tests
Summary: Tests for SQLAlchemy (Python 3)
Group: Development/Python3
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
Requires: %name = %EVR

%description tests
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

This package contains tests for SQLAlchemy.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
# https://setuptools.pypa.io/en/latest/deprecated/commands.html#release-tagging-options
%pyproject_build --backend-config-settings='{"--build-option": ["egg_info", "--tag-build=''", "--no-date"]}'

%install
%pyproject_install

%check
%pyproject_run_pytest -m "not memory_intensive and not mypy and not timing_intensive" test -n4

%files
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}
%exclude %python3_sitelibdir/%mod_name/testing/

%files tests
%python3_sitelibdir/%mod_name/testing/

%changelog
