%define oname snappy
%define pypi_name python-snappy

%def_with check

Name: python3-module-%oname
Version: 0.7.2
Release: alt1

Summary: Python library for the snappy compression library from Google

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/python-snappy
VCS: https://github.com/intake/python-snappy

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libsnappy-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-cramjam
BuildRequires: python3-module-crc32c
%endif

%py3_provides %pypi_name
Provides: python3-module-%pypi_name

%add_python3_req_skip snappy._snappy_cffi

BuildArch: noarch

%description
Python bindings for the snappy compression library from Google.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 test_formats.py
%__python3 test_snappy.py

%files
%doc LICENSE AUTHORS *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/python_%oname-%version.dist-info

%changelog
