%define oname six

%def_with check
%def_with docs

Name: python3-module-%oname
Version: 1.17.0
Release: alt1.1

Summary: Python 2 and 3 compatibility utilities
License: MIT
Group: Development/Python3

BuildArch: noarch
URL: https://pypi.org/project/six
VCS: https://github.com/benjaminp/six

Source: %name-%version.tar
Source2: move.list

%define move_list %(echo `cat %{SOURCE2}`)

%py3_provides %move_list

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-modules-tkinter
BuildRequires: python3-module-pytest
%endif

%if_with docs
BuildRequires: python3-module-sphinx
%endif

%description
Six is a Python 2 and 3 compatibility library. It provides utility
functions for smoothing over the differences between the Python versions
with the goal of writing Python code that is compatible on both Python
versions. See the documentation for more information on what is
provided.

%prep
%setup

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 documentation html
# generate man page
sphinx-build-3 -b man documentation man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/%oname.1 %buildroot%_man1dir/%oname.1
%endif

%check
# check actual state of things regarding to provides
set -o pipefail
PYTHONPATH="$(pwd)" python3 -c "import six;assert six.__version__==\"%version\";modules=six._importer.known_modules.keys();print(*modules, sep='\n')" | sort > move.actual.list
set +o pipefail
cat %SOURCE2 | sort > move.expected.list
diff -y move.expected.list move.actual.list

%tox_check_pyproject

%files
%doc README.rst LICENSE CHANGES
%if_with docs
%doc html
%_man1dir/%oname.1.xz
%endif
%python3_sitelibdir/six.py
%python3_sitelibdir/__pycache__
%python3_sitelibdir/%oname-%version.dist-info

%changelog
