%define _unpackaged_files_terminate_build 1
%define mod_name setuptools_scm
%define pypi_name setuptools-scm

%def_with check

%define add_python_extra() \
%{expand:%%package -n %%name+%1 \
Summary: %%summary \
Group: Development/Python3 \
Requires: %%name \
Provides: python3-module-%%{pep503_name %%pypi_name}+%1 = %%EVR \
%%pyproject_runtimedeps_metadata_extra %1 \
%%description -n %%name+%1' \
Extra "%1" for %%pypi_name. \
%%files -n %%name+%1 \
}

Name: python3-module-%mod_name
Version: 9.2.2
Release: alt1
Summary: The blessed package to manage your versions by scm tags
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/setuptools-scm/
VCS: https://github.com/pypa/setuptools_scm/
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch1: %name-%version-alt.patch
# manually manage extra dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
Requires: git-core mercurial
%py3_provides %pypi_name
# mapping from PyPI name
Provides: python3-module-%pypi_name = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra rich
%pyproject_builddeps_check
BuildRequires: git-core mercurial
%endif

%description
%pypi_name extracts Python package versions from git or hg metadata instead
of declaring them as the version argument or in a Source Code Managed (SCM)
managed file.

Additionally %pypi_name provides setuptools with a list of files that are
managed by the SCM (i.e. it automatically adds all the SCM-managed files to the
sdist). Unwanted files must be excluded via MANIFEST.in or configuring Git
archive.

%add_python_extra rich

%prep
%setup
%patch1 -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup test
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -Wignore

%files
%doc README.*
%_bindir/setuptools-scm
%python3_sitelibdir/setuptools_scm/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
