%define _unpackaged_files_terminate_build 1
%define pypi_name setuptools
%define system_wheels_path %(%__python3 -c 'import os, sys, system_seed_wheels; sys.stdout.write(os.path.dirname(system_seed_wheels.__file__))' 2>/dev/null || echo unknown)

%def_with check
# control vendoring, enable bootstrap to bundle dependencies
%def_without bootstrap

Name: python3-module-%pypi_name
Epoch: 1
Version: 80.9.0
Release: alt1
Summary: Easily download, build, install, upgrade, and uninstall Python packages
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/setuptools/
VCS: https://github.com/pypa/setuptools
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata_extra core
Requires: python3-module-pkg_resources = %EVR
# setuptools has commands for doing binary builds; for them to work always:
Requires: python3-dev
Provides: python3-module-distribute = %EVR
%if_with bootstrap
# hide bundled packages
%add_findprov_skiplist %python3_sitelibdir/setuptools/_vendor/*
%endif
%add_findprov_skiplist %python3_sitelibdir/setuptools/_distutils/*msvc*compiler*.py*

BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

# required internally by setuptools, distutils or pkg_resources
%pyproject_builddeps_metadata_extra core

%if_with check
BuildRequires: /dev/shm
# For the tests of the setuptools commands to do binary builds:
BuildPreReq: python3-dev
%add_pyproject_deps_check_filter pytest-perf
%pyproject_builddeps_metadata_extra test
%endif

# namespace package for system seed wheels which will be used within venv
# created by virtualenv
BuildRequires: python3(system_seed_wheels)

%package -n python3-module-pkg_resources
Summary: Package Discovery and Resource Access for Python3 libraries
Group: Development/Python3
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata_extra core
# Not separated yet:
Conflicts: python3-module-%pypi_name < 39.2.0-alt3

%description
Setuptools is a collection of enhancements to the Python3 distutils
that allow you to more easily build and distribute Python3 packages,
especially ones that have dependencies on other packages.

%global pkg_resources_desc The "pkg_resources" module distributed with "setuptools" provides an API\
for Python libraries to access their resource files, and for extensible\
applications and frameworks to automatically discover plugins.  It also\
provides runtime support for using C extensions that are inside zipfile-format\
eggs, support for merging packages that have separately-distributed modules or\
subpackages, and APIs for managing Python's current "working set" of active\
packages.\
\
Any Python code can make use of pkg_resources at runtime (unlike setuptools,\
whose purpose is preparing packages).

%description -n python3-module-pkg_resources
%pkg_resources_desc

This package contains pkg_resources for Python3.

%package wheel
Summary: %summary
Group: Development/Python3
%py3_requires system_seed_wheels

%description wheel
Provides the seed package for virtualenv(packaged as wheel).

%prep
%setup
%autopatch -p1

# Remove bundled exes
# today's paths containing *.exe
# setuptools/
# setuptools/_distutils/command/
find -type f -name '*.exe' -delete

# do not generate version like release.postdate, we need release one
sed -i '/^tag_build =.*/d;/^tag_date = 1/d' setup.cfg

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
# build upstream version of a wheel (vendored dependencies),
# that wheel is installed by virtualenv into venv,
# otherwise dependencies of setuptools are not available in venv
%pyproject_build

mkdir ./dist_venv
cp -a -t ./dist_venv ./dist/{setuptools-%version-*.whl,.wheeltracker}

%if_without bootstrap
# clean up setuptools' build directory, otherwise its _vendor is packaged
rm -r ./build
# build altlinux version of a wheel (unvendored dependencies),
# setuptools 71.0.0 + prefer installed dependencies
rm -r setuptools/_vendor
%pyproject_build
%endif

%install
%pyproject_install

# since we package python modules as arch dependent
%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
mkdir -p %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

# 71.0.1 includes tests again
pushd %buildroot%python3_sitelibdir/
rm -r \
  ./setuptools/tests \
  ./setuptools/_distutils/tests \
  ./pkg_resources/tests \
  ./pkg_resources/api_tests.txt \
%if_with bootstrap
  ./setuptools/_vendor/importlib_resources/tests \
%endif

popd

# package a built wheel (will be used within venv created by virtualenv)
built_wheel="$(cat ./dist_venv/.wheeltracker)" ||
        { echo Make sure you built a pyproject ; exit 1 ; }
mkdir -p "%buildroot%system_wheels_path"
cp -t "%buildroot%system_wheels_path/" "./dist_venv/$built_wheel"

%check
# avoid rebuilding setuptools' wheel
built_wheel="$(cat ./dist/.wheeltracker)" ||
        { echo Make sure you built a pyproject ; exit 1 ; }
export PRE_BUILT_SETUPTOOLS_WHEEL="$(realpath "./dist/$built_wheel")"
%if_without bootstrap
# some tests depend on presence of the vendored dependencies
export NO_VENDOR=1
# to allow virtualenv's venv use globally installed packages
export VIRTUALENV_SYSTEM_SITE_PACKAGES=1
# to make pip install built wheel of setuptools and ignore the globally
# installed one of the same version (see setuptools/tests/fixtures.py::venv)
export PIP_IGNORE_INSTALLED=1
# required for `setup.py develop` which uses pip internally since setuptools 80
export PIP_NO_BUILD_ISOLATION=NO
%endif
%pyproject_run_pytest -vra

%files
%doc *.rst
%python3_sitelibdir/_distutils_hack/
%python3_sitelibdir/distutils-precedence.pth
%python3_sitelibdir/setuptools

%files -n python3-module-pkg_resources
%python3_sitelibdir/pkg_resources
# People write "setuptools" in *.egg-info/requires.txt (or in setup.py's requires)
# even if they use only the pkg_resources part;
# if setuptools-*.egg-info is not present, pkg_resources.load_entry_point() fails
# (for no real reason). Unfortunately, they have nothing better to write there...
# So we fool this mechanism by putting this file even
# if having incomplete setuptools code.
# Our autoreqs will take over the duty of tracking the real dependencies.
# (In future, we could patch their requires.txt.)
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%files wheel
%system_wheels_path/setuptools-%version-*.whl

%changelog
