# -*- mode: rpm-spec; coding: utf-8 -*-
%define oname serial

%def_without doc_package
%def_without jython

Name: python3-module-%oname
Version: 3.5
Release: alt3
Summary: Serial port access for python
Summary(ru_RU.UTF-8): Доступ к последовательному порту из python
# https://github.com/pyserial/pyserial
Source: %name-%version.tar
License: Python
Group: Development/Python3
Prefix: %_prefix
Url: https://github.com/pyserial/pyserial
BuildArch: noarch
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-pyserial = %EVR
BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3-module-setuptools
%add_python3_req_skip System clr

Conflicts: python-module-%oname
Obsoletes: python-module-%oname

%description
pyserial capsulates the access for the serial port. It provides
backends for standard Python running on Windows, Linux, BSD (possibly
any POSIX compilant system) and Jython. The module automaticaly
selects the appropriate backend.

This module contains POSIX compatible serial port access.
It's built for python %_python_version

%description -l ru_RU.UTF-8
С помощью модулей pyserial можно работать с последовательным портом в
стандартном Python, запущенном на Windows, Linux, BSD (возможно, любой
POSIX-совместимой системе) или Jython. Модуль автоматически выбирает
подходящий для данной системы механизм доступа.

Этот модуль содержит методы доступа к последовательному порту, пригодные
для POSIX-совместимых систем.
Он собран для Python версии %_python_version

%if_with jython
%package jython
Summary: Jython compatible serial port access
Group: Development/Python3

%description jython
This module capsulates the access for the serial port. It provides
backends for standard Python running on Windows, Linux, BSD (possibly
any POSIX compilant system) and Jython. The module automaticaly
selects the appropriate backend.

This module contains Jython compatible serial port access.
It's built for python %__python_version
%endif

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%files
%doc CHANGES.rst README.rst LICENSE.txt
%_bindir/*
%python3_sitelibdir/serial/
%python3_sitelibdir/%{pyproject_distinfo pyserial}/
%exclude %python3_sitelibdir/serial/*java.py*
%exclude %python3_sitelibdir/serial/__pycache__/*java.*
%exclude %python3_sitelibdir/serial/*win32.py*
%exclude %python3_sitelibdir/serial/__pycache__/*win32.*
%exclude %python3_sitelibdir/serial/tools/*windows.py*
%exclude %python3_sitelibdir/serial/tools/__pycache__/*windows.*
%exclude %python3_sitelibdir/serial/serialcli.py*
%exclude %python3_sitelibdir/serial/__pycache__/serialcli.*
%doc examples

%if_with jython
%files jython
%python3_sitelibdir/serial/*java.py*
%endif

%changelog
