%define _unpackaged_files_terminate_build 1

%define oname seaborn

%ifnarch i586
%def_with check
%else
%def_without check
%endif

Name: python3-module-seaborn
Version: 0.13.2
Release: alt3
Summary: Seaborn: statistical data visualization
License: BSD-3-Clause
Group: Sciences/Other
URL: https://pypi.org/project/seaborn/

VCS: https://github.com/mwaskom/seaborn
Source: %name-%version.tar
Patch: seaborn-0.13.2-mpl-tick.patch
Patch1: seaborn-0.13.2-np2-test-fix.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-flit-core
%if_with check
BuildRequires: python3-module-matplotlib
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3-module-pandas
BuildRequires: python3-module-pandas-tests
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-contourpy
BuildRequires: python3-module-statsmodels
%endif

%description
Seaborn is a library for making attractive and informative statistical graphics
in Python. It is built on top of matplotlib and tightly integrated with the
PyData stack, including support for numpy and pandas data structures and
statistical routines from scipy and statsmodels.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

# Remove testing file, that brings numpy.testing
rm -fv %buildroot%python3_sitelibdir/%oname/_testing.py

%check
%pyproject_run_pytest -n auto

%files
%doc LICENSE.md README.md
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
