# errors on i586 and aarch64
%def_without check
%def_with pythran

%define modname scipy
%define ver_major 1.15
%define ver_minor 3

%define numpy_version 1.16.5

Name: python3-module-%modname
Version: %ver_major.%ver_minor
Release: alt3

Summary: SciPy is the library of scientific codes
License: BSD-3-Clause
Group: Development/Python3

Url: https://www.scipy.org/
VCS: git://github.com/scipy/scipy.git
Source0: %name-%version.tar
Source1: site.cfg
# submodules by update-submodules.sh
Source2: %name-%version-doc-source-_static-scipy-mathjax.tar
Source3: %name-%version-scipy-_lib-array_api_compat.tar
Source4: %name-%version-scipy-_lib-array_api_extra.tar
Source5: %name-%version-scipy-_lib-boost_math.tar
Source6: %name-%version-scipy-_lib-cobyqa.tar
Source7: %name-%version-scipy-_lib-pocketfft.tar
Source8: %name-%version-scipy-_lib-unuran.tar
Source9: %name-%version-scipy-sparse-linalg-_propack-PROPACK.tar
Source10: %name-%version-subprojects-highs.tar
Source11: datasets.tar

Patch: 0001-ALT-Make-use-of-local-storage-of-datasets-as-a-defau.patch

BuildRequires(pre): rpm-macros-make
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ gcc-fortran
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel python3-module-numpy-testing
BuildRequires: python3-module-Cython
BuildRequires: meson
BuildRequires: python3-module-mesonpy
BuildRequires: python3-module-html5lib
BuildRequires: python3-module-matplotlib
BuildRequires: python3-module-pybind11
%if_with pythran
BuildRequires: python3-module-pythran
%endif
BuildRequires: libopenblas-devel

%ifarch %e2k
BuildRequires: eml-devel-compat-lapack
BuildRequires: eml-devel-compat-blas
%else
BuildRequires: liblapack-devel
%endif

Requires: %python3_sitelibdir_noarch
Requires: python3-module-numpy >= %numpy_version
%add_python3_req_skip _min_spanning_tree _shortest_path _tools
%add_python3_req_skip _traversal sympy
%if_with check
BuildRequires: /usr/bin/pytest3
BuildRequires: python3-module-numpy-tests
BuildRequires: /proc
BuildRequires: python3-module-pooch
BuildRequires: python3-module-hypothesis
%add_python3_req_skip scipy.fft.tests
%else
%add_python3_req_skip numpy.testing
%endif

# special/_precompute/struve_convergence.py
%add_python3_req_skip matplotlib.pyplot

%add_python3_req_skip cupy
%add_python3_req_skip cupy.cuda.device
%add_python3_req_skip cupy.fft
%add_python3_req_skip cupy.linalg
%add_python3_req_skip scipy.special._mptestutils
%add_python3_req_skip scipy.special.tests.test_hyp2f1
%add_python3_req_skip torch
%add_python3_req_skip torch.fft
%add_python3_req_skip torch.linalg

# Useless requirements for scipy/_lib/array_api_compat
# that makes dependency circle
%add_python3_req_skip dask.array
%add_python3_req_skip dask.array.fft
%add_python3_req_skip dask.array.linalg

%description
SciPy is the library of scientific codes built on top of NumPy.

%package devel
Summary: Development files of SciPy (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-devel
Requires: libnumpy-py3-devel

%description devel
SciPy is the library of scientific codes built on top of NumPy.

This package contains development files of SciPy.

%prep
%setup -a2 -a3 -a4 -a5 -a6 -a7 -a8 -a9 -a10 -a11
%patch -p1
install -p -m644 %SOURCE1 .
sed -i 's|@LIBDIR@|%_libdir|g' site.cfg doc/Makefile
sed -i 's|@PYVER@|%_python_version|g' doc/Makefile
sed -i 's|@PYSUFF@|3|' site.cfg

%if_without check
# Find and comment out Pytest imports, since main package should
# not require test deps
grep -zPqsr '[ ]*from scipy._lib._testutils import PytestTester\n[ ]*test = PytestTester\(__name__\)\n[ ]*del PytestTester\n' || exit 1
grep -zPrl '[ ]*from scipy._lib._testutils import PytestTester\n[ ]*test = PytestTester\(__name__\)\n[ ]*del PytestTester\n' | xargs \
sed -i '/from scipy._lib._testutils import PytestTester/,/del PytestTester/ {s/^/# /}'
%endif

mkdir -p ~/.matplotlib
cp %_datadir/matplotlib/mpl-data/matplotlibrc \
	~/.matplotlib/
sed -i 's|^\(backend\).*|\1 : Agg|' ~/.matplotlib/matplotlibrc

%build
%ifarch %e2k
# as of lcc 1.25.17 (mcst#6255)
%add_optflags -DPOCKETFFT_NO_VECTORS
# fixup "EML instead of OpenBLAS/LAPACK" setup
sed -i -e 's/lapack, /clapack, eml_algebra_mt, /g' -e 's/openblas, /blas, /g' site.cfg
%endif
%if_without pythran
sed -i '/use-pythran/s/true/false/' meson_options.txt
%endif
%ifnarch %e2k
# Solution for ALT#48852
sed -i 's/lapack=openblas/lapack=lapack/' meson.build
%endif

export SCIPY_USE_PYTHRAN=0%{?with_pythran}
%add_optflags -I%_includedir/suitesparse -fno-strict-aliasing %optflags_shared
%pyproject_build

%install
export SCIPY_USE_PYTHRAN=0%{?with_pythran}
%pyproject_install

find %buildroot%python3_sitelibdir -type f -exec \
	sed -i 's|#! %_bindir/env python|#!%_bindir/python3|' -- '{}' + ||:
find %buildroot%python3_sitelibdir -type f -exec \
	sed -i 's|#!%_bindir/env python|#!%_bindir/python3|' -- '{}' + ||:

# headers
pushd %modname
for i in $(find ./ -name '*.h'); do
    dir=$(echo $i|sed 's|\(.*\)/.*|\1|')
    install -d %buildroot%_includedir/%modname-py3/$dir
    install -p -m644 $i \
	%buildroot%_includedir/%modname-py3/$dir
done
popd

pushd %buildroot%python3_sitelibdir/%modname/sparse/csgraph
for i in $(ls *.so); do
	ln -s %python3_sitelibdir/%modname/sparse/csgraph/$i \
		%buildroot%python3_sitelibdir/
done
popd

%if_without check
# don't package tests and tests'check
for i in $(find %buildroot%python3_sitelibdir \
               -name tests -type d \
               -o -name 'conftest.*' -type f \
               -o -name '_testutils.*' -type f \
               -o -name 'gammainc_data.*' -type f \
               -o -name '_mptestutils.*' -type f)
do
	rm -rv "$i"
done
%endif

%find_lang %name

%check
export XDG_CACHE_HOME=$PWD
pushd %buildroot/%python3_sitelibdir
pytest3 scipy -k 'not test_basic_functions and not test_cython and not TestDatasets'
rm -rv .pytest_cache

for i in $(find %buildroot%python3_sitelibdir \
               -name tests -type d \
               -o -name 'conftest.*' -type f \
               -o -name '_testutils.*' -type f \
               -o -name 'gammainc_data.*' -type f \
               -o -name '_mptestutils.*' -type f)
do
	rm -r "$i"
done

grep -zPqsr '[ ]*from scipy._lib._testutils import PytestTester\n[ ]*test = PytestTester\(__name__\)\n[ ]*del PytestTester\n' || exit 1
grep -zPrl '[ ]*from scipy._lib._testutils import PytestTester\n[ ]*test = PytestTester\(__name__\)\n[ ]*del PytestTester\n' %buildroot%python3_sitelibdir/%modname | xargs \
sed -i '/from scipy._lib._testutils import PytestTester/,/del PytestTester/ {s/^/# /}'

%files -f %name.lang
%python3_sitelibdir/_*.so
%python3_sitelibdir/%modname
%python3_sitelibdir/%modname-%version.dist-info

%files devel
%_includedir/%modname-py3

%changelog
