%define _unpackaged_files_terminate_build 1
%define pypi_name rtree
%define pypi_nname rtree
%define mod_name rtree

%def_with check

Name: python3-module-%pypi_nname
Version: 1.4.0
Release: alt1

Summary: R-Tree spatial index for Python GIS
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/Rtree/
Vcs: https://github.com/Toblerity/rtree

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
Requires: spatialindex
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: spatialindex
%endif

%description
Rtree is a ctypes Python wrapper of libspatialindex that provides a
number of advanced spatial indexing features for the spatially curious
Python user. These features include:

* Nearest neighbor search
* Intersection search
* Multi-dimensional indexes
* Clustered indexes (store Python pickles directly with index entries)
* Bulk loading
* Deletion
* Disk serialization
* Custom storage implementation (to implement spatial indexing in ZODB,
  for example)

%prep
%setup
%autopatch -p1

# remove setup.py to make the package noarch
rm setup.py

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc CHANGES.rst CREDITS.txt LICENSE.txt README.md
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
