%define _unpackaged_files_terminate_build 1

%def_with check

Name: python3-module-pywlroots
Version: 0.17.0
Release: alt2

Summary: Python binding to the wlroots library using cffi
License: NCSA
Group: Development/Python3

Url: https://github.com/flacjacket/pywlroots
Source: %name-%version.tar
Source1: wlr-%version.tar

Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-xkbcommon
BuildRequires: python3-module-pywayland
BuildRequires: libxkbcommon-devel
BuildRequires: libinput-devel
BuildRequires: libxcb-devel
BuildRequires: libxcbutil-icccm-devel

# wlroots is poorly maintained, so just vendor headers from libwlroots-devel
# See: https://bugzilla.altlinux.org/54843
# See: https://lists.altlinux.org/pipermail/devel/2025-June/219307.html
BuildRequires: libwayland-server-devel
BuildRequires: libpixman-devel
BuildRequires: libwlroots12
%global libwlroots_file libwlroots.so.12

%if_with check
BuildRequires: python3-module-pytest
%endif

%description
A Python binding to the wlroots library using cffi. The library uses
pywayland to provide the Wayland bindings and python-xkbcommon to
provide wlroots keyboard functionality.

%prep
%setup -a1
%patch0 -p1

sed -i -e "/libraries=/ s/wlroots/:%libwlroots_file/" ./wlroots/ffi_build.py

%build
export CFLAGS="-I$PWD/wlroots/include"
%__python3 ./wlroots/ffi_build.py
%pyproject_build

%install
%pyproject_install

# hack to drop .abi3 from binaries
find %buildroot -name '*.abi3*' -exec rename '.abi3' '' {} \;

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc LICENSE README.rst
%python3_sitelibdir/wlroots
%python3_sitelibdir/%{pyproject_distinfo pywlroots}

%changelog
