%define _unpackaged_files_terminate_build 1
%define pypi_name pytz
%define mod_name %pypi_name

Name: python3-module-%pypi_name
Version: 2025.2
Release: alt1
Epoch: 1
Summary: World timezone definitions, modern and historical
License: MIT
Group: Development/Python
Url: https://pypi.org/project/pytz
VCS: https://github.com/stub42/pytz
BuildArch: noarch
Source0: %pypi_name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%endif

%description
pytz brings the Olson tz database into Python. This library allows accurate and
cross platform timezone calculations using Python 2.4 or higher. It also solves
the issue of ambiguous times at the end of daylight saving time, which you can
read more about in the Python Library Reference (datetime.tzinfo).

%prep
%setup -n %pypi_name-%version
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
# sync to .github/workflows/main.yml
%pyproject_run -- bash -s <<-'ENDTESTS'
set -eux
python %mod_name/tests/test_lazy.py -vv
python %mod_name/tests/test_tzinfo.py -vv
python %mod_name/tests/test_docs.py -vv
ENDTESTS

%files
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
