%define _unpackaged_files_terminate_build 1
%define mod_name %pypi_name
%define pypi_name pyttsx3

%def_with check

Name: python3-module-%pypi_name

Version: 2.99
Release: alt2
Summary: Offline Text To Speech (TTS) converter for Python 
License: MPL-2.0
Group: Development/Python3
Url: https://pypi.org/project/pyttsx3/
Vcs: https://github.com/nateshmbhat/pyttsx3
BuildArch: noarch

Source: %name-%version.tar
#eSpeak voice count varies between versions
Patch1: eSpeak-speak-test-alt.patch
#skip test_listening_for_events
Patch2: not-test-listening-for-events-alt.patch

BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: espeak-ng
BuildRequires: ffmpeg
BuildRequires: libespeak-ng1
BuildRequires: alsa-utils
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: aplay
%endif
#Remove macOS-specific Python dependencies from auto-generated RPM requires.
%add_python3_req_skip AVFoundation CoreFoundation Foundation objc

%py3_provides %pypi_name

%description
%summary

%prep
%setup
%autopatch -p1
current_version=$(sed -n -E 's/^version *= *"(.*)"/\1/p' pyproject.toml)
if [ "$current_version" != "%version" ]; then
    sed -i 's/^version *= *".*"/version = "%version"/' pyproject.toml
fi

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc README.md
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%pypi_name-%version.dist-info
%exclude %python3_sitelibdir/%pypi_name/drivers/nsss.py
%exclude %python3_sitelibdir/%pypi_name/drivers/sapi5.py

%changelog
