%define _unpackaged_files_terminate_build 1
%define pypi_name python-lsp-server
%define mod_name pylsp

%def_with check

Name: python3-module-%pypi_name
Version: 1.13.0
Release: alt1

Summary: Python Language Server for the Language Server Protocol
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/python-lsp-server/
Vcs: https://github.com/python-lsp/python-lsp-server

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra all
%pyproject_builddeps_metadata_extra test
# needed but filtered out by default
BuildRequires: python3-module-flake8
BuildRequires: python3-module-pylint
BuildRequires: python3-module-appdirs
BuildRequires: python3-module-black
%endif

%description
A Python 3.8+ implementation of the Language Server Protocol.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -o=addopts=-Wignore test

%files
%doc LICENSE CHANGELOG.md
%_bindir/pylsp
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
