%define pypi_name pytest_httpserver

%def_enable check

Name: python3-module-pytest-httpserver
Version: 1.1.3
Release: alt1

Summary: HTTP server for pytest
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/%pypi_name

Vcs: https://www.github.com/csernazs/pytest-httpserver.git
Source: https://pypi.io/packages/source/p/%pypi_name/%pypi_name-%version.tar.gz

BuildArch: noarch

Provides: python3-module-%pypi_name = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-wheel python3-module-poetry-core >= 1.1
%{?_enable_check:
BuildRequires: python3-module-werkzeug python3-module-pytest python3-module-flake8
BuildRequires: python3-module-pytest python3-module-pytest-cov python3-module-coverage
BuildRequires: python3-module-requests python3-module-mypy python3-module-toml}

%description
This library is designed to help to test http clients without contacting
the real http server. In other words, it is a fake http server which is
accessible via localhost can be started with the pre-defined expected
http requests and their responses.

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir_noarch
py.test3

%files
%python3_sitelibdir_noarch/%pypi_name/
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}
%doc CHANGES* README* LICENSE

%changelog
