%define _unpackaged_files_terminate_build 1
%define pypi_name pytest-django

%def_with check

Name: python3-module-%pypi_name
Version: 4.11.1
Release: alt1
Summary: A Django plugin for py.test
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/pytest-django/
Vcs: https://github.com/pytest-dev/pytest-django
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter django-configurations
%pyproject_builddeps_metadata_extra testing
BuildRequires: python3-module-django-dbbackend-sqlite3
%endif

%description
pytest-django allows you to test your Django project/applications with
the pytest testing tool.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
# pytest_django_test package must be importable by Pytest's subprocesses
export PYTHONPATH=$(pwd)
%pyproject_run_pytest -ra -Wignore tests

%files
%doc README.*
%python3_sitelibdir/pytest_django/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
