%define _unpackaged_files_terminate_build 1
%define pypi_name pytest-cov

%def_with check

Name: python3-module-%pypi_name
Version: 6.3.0
Release: alt1
Summary: Pytest plugin for measuring coverage
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pytest-cov/
Vcs: https://github.com/pytest-dev/pytest-cov
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
%py3_provides %pypi_name
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter hunter
%pyproject_builddeps_metadata_extra testing
BuildRequires: python3-module-coverage
%endif

%description
This plugin produces coverage reports. Compared to just using coverage run this
plugin does some extras:
- Subprocess support: you can fork or run stuff in a subprocess and will get
  covered without any fuss.
- Xdist support: you can use all of pytest-xdist's features and still get
coverage.
- Consistent pytest behavior. If you run coverage run -m pytest you will have
  slightly different sys.path (CWD will be in it, unlike when running pytest).

%prep
%setup
%patch -p1

grep -qsF 'time.sleep(1)' tests/test_pytest_cov.py || exit 1
sed -i 's/time\.sleep(1)/time.sleep(5)/g' tests/test_pytest_cov.py

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
# PYTHONPATH_ALT sets PYTHONPATH to measure coverage for subprocesses because
# *.pth files are processed by site module *before* getting access to
# global site packages
export PYTHONPATH_ALT=$(python3 -c "import os, sys, site;print(os.pathsep.join(site.getsitepackages([sys.base_prefix])))")
# let virtual environments have access to globally installed packages by default
export VIRTUALENV_SYSTEM_SITE_PACKAGES=1
%pyproject_run_pytest -vra -Wignore

%files
%doc README.*
%python3_sitelibdir/pytest-cov.pth
%python3_sitelibdir/pytest_cov/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
