%define _unpackaged_files_terminate_build 1
%define pypi_name pytest

%def_with check

Name: python3-module-%pypi_name
Version: 8.4.2
Release: alt1
Summary: Python test framework
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pytest/
VCS: https://github.com/pytest-dev/pytest.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
# manually manage dependencies with metadata
AutoReq: yes, nopython3
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata_extra dev
BuildRequires: /dev/pts
BuildRequires: /dev/shm
%endif

# don't provide limited compat shim for python3(py) from python3-module-py
%add_findprov_skiplist %python3_sitelibdir/py.py

%description
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%package -n pytest3
Summary: Additional executable for pytest
Group: Development/Python3
Requires: python3-module-%pypi_name = %EVR
# It simply has executables with the same filename:
Conflicts: python3-module-logilab-common < 1.0.2-alt2.hg20150708

%description -n pytest3
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%prep
%setup
%patch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install
mv %buildroot%_bindir/py.test -T %buildroot%_bindir/py.test3
mv %buildroot%_bindir/pytest -T %buildroot%_bindir/pytest3
ln -s py.test3 %buildroot%_bindir/py.test-3
ln -s pytest3 %buildroot%_bindir/pytest-3

%check
# add workaround for https://github.com/pytest-dev/pytest/issues/6297
export TERM=xterm
# don't use %%pyproject_run_pytest to avoid circular dependency
%pyproject_run -- python3 -m pytest -vra

%files
%doc CHANGELOG.rst README.rst
%_bindir/py.test3
%_bindir/py.test-3
%python3_sitelibdir/pytest/
%python3_sitelibdir/_pytest/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%python3_sitelibdir/py.py
%python3_sitelibdir/__pycache__/py.*

%files -n pytest3
%_bindir/pytest3
%_bindir/pytest-3

%changelog
