%define _unpackaged_files_terminate_build 1

%define pypi_name pysnmp
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 7.1.22
Release: alt1
Summary: Python library for SNMP
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/pysnmp
Vcs: https://github.com/lextudio/pysnmp
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# renamed from pysnmp4
Provides: python3-module-pysnmp4 = %EVR
Obsoletes: python3-module-pysnmp4 <= 4.4.12-alt1
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
# not packaged
%add_pyproject_deps_check_filter pep8-naming
%add_pyproject_deps_check_filter pysmi
%add_pyproject_deps_check_filter bump2version
%pyproject_builddeps_metadata_extra dev
%endif

%description
This is a pure-Python, open source and free implementation of v1/v2c/v3 SNMP
engine.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
# skip tests requiring pysmi (not packaged) or internet, sort failures later
%pyproject_run_pytest -vra \
    --ignore tests/smi/manager/test_mib-tree-inspection.py \
    --ignore tests/smi/manager/test_configure-mib-viewer-and-resolve-pdu-varbinds.py \
    --ignore tests/hlapi/v3arch/asyncio/manager/cmdgen/test_v2c_bulkwalk.py \
    --ignore tests/hlapi/v1arch/asyncio/manager/cmdgen/test_v1arch_v1_get.py \
    --ignore tests/hlapi/v1arch/asyncio/manager/cmdgen/test_v1arch_v2c_bulk.py \
    --ignore tests/hlapi/v1arch/asyncio/manager/cmdgen/test_v1arch_v2c_bulkwalk.py \
    --ignore tests/hlapi/v3arch/asyncio/agent/ntforg/test_default-v1-trap.py \
    --ignore tests/hlapi/v3arch/asyncio/manager/cmdgen/test_custom_asn1_mib_search_path.py \
    --ignore tests/hlapi/v3arch/asyncio/manager/cmdgen/test_v1_get.py \
    --ignore tests/hlapi/v3arch/asyncio/agent/ntforg/test_v3-trap.py \
    --ignore tests/smi/manager/test_convert-between-pdu-varbinds-and-mib-objects.py \
    --deselect tests/hlapi/v1arch/asyncio/manager/cmdgen/test_v1arch_v1_set.py::test_v1_set_mac_address \

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
