%define oname pyodbc

# Tests need database connection
%def_without check

Name:    python3-module-%oname
Version: 5.3.0
Release: alt1

Summary: Python ODBC bridge
License: MIT-0
Group:   Development/Python3
URL:     https://pypi.org/project/pyodbc/
VCS:     https://github.com/mkleehammer/pyodbc

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libunixODBC-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-env
%endif

%description
pyodbc is an open source Python module that makes accessing ODBC databases
simple. It implements the DB API 2.0 specification but is packed with even
more Pythonic convenience.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v tests/postgresql_test.py

%files
%doc *.md *.txt
%python3_sitelibdir/%oname.*.so
%python3_sitelibdir/%oname.pyi
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
