%define pypi_name pymediainfo
%def_enable check

Name: python3-module-%pypi_name
Version: 7.0.1
Release: alt1

Summary: A Python 3 wrapper for the mediainfo library
Group: Development/Python3
License: MIT
Url: https://pypi.python.org/pypi/%pypi_name

Vcs: https://github.com/sbraz/pymediainfo.git

Source: https://pypi.io/packages/source/p/%pypi_name/%pypi_name-%version.tar.gz

BuildArch: noarch

Requires: libmediainfo

%define python3_ver 3.9

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel >= %python3_ver python3(wheel) python3(pdm.backend)
%{?_enable_check:BuildRequires: python3(tox) python3(xdist) libmediainfo
BuildRequires: python3(mypy) python3(pylint)}

%description
This Python3 module provides a wrapper around the MediaInfo library.

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check

%files
%python3_sitelibdir_noarch/%pypi_name/
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}
%doc README*


%changelog
