%define _unpackaged_files_terminate_build 1
%define pypi_name pylint
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 3.3.8
Release: alt1
Summary: Python code static checker
License: GPLv2+
Group: Development/Python3
Url: https://pypi.org/project/pylint/
Vcs: https://github.com/pylint-dev/pylint
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
Provides: pylint-py3 = %EVR
Obsoletes: pylint-py3 < %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%set_pyproject_deps_check_filter towncrier
%pyproject_builddeps_metadata_extra testutils
%pyproject_builddeps_metadata_extra spelling
%pyproject_builddeps_check
# PyEnchant's spelling dictionary
BuildRequires: hunspell-en_US
%endif

%description
Pylint is a static code analyser for Python 2 or 3. The latest version supports
Python 3.7.2 and above.

Pylint analyses your code without actually running it. It checks for errors,
enforces a coding standard, looks for code smells, and can make suggestions
about how the code could be refactored.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements_test_min.txt
%endif

%build
%pyproject_build

%install
%pyproject_install
# do not pack tests
rm -r %buildroot%python3_sitelibdir/pylint/test*

pushd %buildroot%_bindir
for i in $(ls); do
       mv $i $i.py3
done

%check
%pyproject_run_pytest -ra --benchmark-disable tests

%files
%doc README.rst
%_bindir/pylint.py3
%_bindir/pyreverse.py3
%_bindir/symilar.py3
%_bindir/pylint-config.py3
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
