%define oname pyftpdlib
%define descr \
Python FTP server library provides a high-level portable interface to easily \
write asynchronous FTP servers with Python. pyftpdlib is currently the most \
complete RFC-959 FTP server implementation available for Python programming \
language.

%def_without docs

Name: python3-module-%oname
Version: 2.1.0
Release: alt1

Summary: Python FTP server library
Summary(ru_RU.UTF-8): Модуль Python FTP-сервера

Group: Development/Python3
License: MIT and BSD
URL: https://pypi.org/project/pyftpdlib
VCS: https://github.com/giampaolo/pyftpdlib

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx python3-module-sphinx_rtd_theme
%endif

BuildArch: noarch

%py3_provides %oname

%description -l ru_RU.UTF-8
Модуль Python FTP-сервера беспечивает портативный высокоуровневый интерфейс
для лёгкого написания асинхронного FTP сервера на Python. pyftpdlib сейчас --
наиболее полная реализация RFC-959 FTP-сервера для Python.

%description
%descr

%if_with docs
%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
%descr

This package contains documentation for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
%descr

This package contains pickles for %oname.
%endif

%prep
%setup

sed -i -e "s|^__ver__ = '[^']*'|__ver__ = '%version'|" pyftpdlib/__init__.py

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%pyproject_build

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs pickle
%make -C docs html
%make -C docs man
%endif

%install
%pyproject_install

%if_with docs
mkdir -p %buildroot%python3_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname
mkdir -p %buildroot%_man1dir
cp -fR docs/_build/man/* %buildroot%_man1dir
%endif

%files
%doc CREDITS LICENSE *.rst demo/
%_bindir/*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%if_with docs
%_man1dir/*
%exclude %python3_sitelibdir/%oname/pickle
%endif

%if_with docs
%files docs
%doc docs/_build/html/*

%files pickles
%python3_sitelibdir/%oname/pickle
%endif

%changelog
