%define _unpackaged_files_terminate_build 1
%define pypi_name pyfakefs
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 5.10.1
Release: alt1
Summary: Implements a fake file system that mocks the Python file system modules
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/pyfakefs/
Vcs: https://github.com/pytest-dev/pyfakefs
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata

BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_check
%endif

%description
%pypi_name implements a fake file system that mocks the Python file system
modules. Using pyfakefs, your tests operate on a fake file system in memory
without touching the real disk. The software under test requires no
modification to work with pyfakefs.

%prep
%setup
%autopatch -p1

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%if_with check
%pyproject_deps_resync_check_pipreqfile requirements.txt
%endif

%build
%pyproject_build

%install
%pyproject_install
# don't package tests (useless)
rm -r %buildroot%python3_sitelibdir/%pypi_name/{tests,pytest_tests}/

%check
# .github/workflows/testsuite.yml
%pyproject_run -- python -m %mod_name.tests.all_tests
%pyproject_run -- python -m %mod_name.tests.all_tests_without_extra_packages
%pyproject_run -- python -m pytest %mod_name/pytest_tests/

%files
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
