%define oname pydot

%def_with check

Name: python3-module-%oname
Version: 4.0.1
Release: alt1

Summary: Python interface to Graphiz's Dot

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/pydot
VCS: https://github.com/pydot/pydot

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-parameterized
BuildRequires: python3-module-pyparsing
BuildRequires: python3-module-chardet
BuildRequires: graphviz
%endif

Requires: %_bindir/dot

%description
An interface for creating both directed and non directed graphs from
Python. Currently all attributes implemented in the Dot language are
supported (up to Graphviz 1.16).

Output can be inlined in Postscript into interactive scientific
environments like TeXmacs, or output in any of the format's supported
by the Graphviz tools dot, neato, twopi.

%prep
%setup

sed -i 's/license = "MIT"/license = {file = "LICENSES\/MIT.txt"}/' pyproject.toml
sed -i '14d;15d;16d' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
python3 test/test_pydot.py

%files
%doc ChangeLog
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
