%define _unpackaged_files_terminate_build 1
%define pypi_name pydocstyle
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 6.3.0
Release: alt2
Summary: Python docstring style checker
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pydocstyle/
Vcs: https://github.com/PyCQA/pydocstyle
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
Patch1: fix-tests-py312.patch
%pyproject_runtimedeps_metadata
# Conflicts due to binaries in /usr/bin
Conflicts: python-module-%pypi_name
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter types-
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
pydocstyle is a static analysis tool for checking
compliance with Python docstring conventions.

pydocstyle supports most of PEP 257 out of the box,
but it should not be considered a reference implementation.

%prep
%setup
%autopatch -p1
# upstream uses dev version for git tree
sed -i 's/^version = "@VERSION@"$/version = "%version"/' pyproject.toml
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements/tests.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -Wignore \
    --ignore=src/tests/test_integration.py \
    src/tests

%files
%doc README.rst
%_bindir/pydocstyle
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
