%define _unpackaged_files_terminate_build 1
%define pypi_name pydantic-settings
%define mod_name pydantic_settings
%def_with check

Name: python3-module-%pypi_name
Version: 2.11.0
Release: alt1

Summary: Settings management using pydantic
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pydantic-settings/
Vcs: https://github.com/pydantic/pydantic-settings
BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-macros-pyproject
BuildRequires: rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter pytest-examples
%add_pyproject_deps_check_filter typed-ast
%pyproject_builddeps_check
%pyproject_builddeps_metadata
%endif

%description
Settings management using Pydantic, this is the new official home of
Pydantic's BaseSettings.
This package was kindly donated to the https://github.com/pydanticby
Daniel Daniels, see https://github.com/pydantic/pydantic/pull/4492
for discussion.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup testing
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# tests/test_docs.py: do not execute docs tests
# tests/test_source_azure_key_vault.py: there's error with new
# python3-module-azure-keyvault-secrets==4.9.0 and we don't need to check
# azure functional.
# tests/test_source_gcp_secret_manager.py: there's no sense testing
# google-cloud-secret-manager since that package is no in Sisyphus
%pyproject_run_pytest \
    --ignore='tests/test_docs.py' \
    --ignore='tests/test_source_azure_key_vault.py' \
    --ignore='tests/test_source_gcp_secret_manager.py'

%files
%doc README.md LICENSE docs
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
