%define _unpackaged_files_terminate_build 1
%def_with check
%define pypi_name pydantic

Name: python3-module-%pypi_name
Version: 2.12.1
Release: alt1

Summary: Data parsing and validation using Python type hints
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pydantic
Vcs: https://github.com/pydantic/pydantic
BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-macros-pyproject
BuildRequires: rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter eval-type-backport
%add_pyproject_deps_check_filter pytest-codspeed
%add_pyproject_deps_check_filter pytest-memray
%pyproject_builddeps_metadata
%pyproject_builddeps_metadata_extra email
%pyproject_builddeps_check
%endif

# Manually manage extras dependencies with metadata.
AutoReq: yes, nopython3

%description
Data validation and settings management using Python type hints.

Fast and extensible, pydantic plays nicely with your linters/IDE/brain.
Define how data should be in pure, canonical Python 3.7+; validate it
with pydantic.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup dev
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# tests/test_docs.py: skip testing of documentation
#
# --benchmark-skip:
# Skip executing tests from tests/benchmark. These tests don't have sense for
# our check section, because of they test only pydantic work speed.
# Also generating north_star_data.json at each test exec and comparing it with
# expected md5sum leads to failed build, because of Faker or something else has
# been updated.
%pyproject_run_pytest --ignore='tests/test_docs.py' --benchmark-skip

%files
%doc LICENSE *.md
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
